<?php

/**
 * @author InterAgilite
 * @copyright 2007-2020 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 * <ModuleName> => prixanconnect
 * <FileName> => UpdateProducts.php
 * Format expected: <ModuleName><FileName>ModuleFrontController
 */

class PrixanconnectUpdateProductsModuleFrontController extends ModuleFrontController
{
    public function initContent()
    {
        header('Content-type: application/json');
        // $request->getContent();
        die(Tools::jsonEncode(array('check' => 'you must call this url with POST method')));
    }
    private function getProductAttributes($product_id)
    {
        $query = "SELECT id_product_attribute FROM `" . _DB_PREFIX_ . "product_attribute` WHERE id_product=" . $product_id;

        $results = Db::getInstance()->executeS($query);
        return $results;
    }
    private function getProductFromAttributeId($product_attribute_id)
    {
        $query = "SELECT id_product FROM `" . _DB_PREFIX_ . "product_attribute` WHERE id_product_attribute=" . $product_attribute_id;

        $results = Db::getInstance()->executeS($query);
        if ($results && count($results) > 0) {
            return (int)$results[0]['id_product'];
        }
        return null;
    }
    private function updateProductPriceBase($product, $newPrice, $id_shop)
    {
        $product->price = $newPrice;
        $product->update();
    }
    private function updateProductPricePromo($product, $newPrice, $id_shop)
    {
        if (empty($id_shop)) {
            $id_shop = 0;
        }

        $newspec = new SpecificPrice();
        $newspec->id_product = (int) $product->id;

        // $tax_manager = TaxManagerFactory::getManager(
        //     $address,
        //     Product::getIdTaxRulesGroupByIdProduct((int) $id, $this->context)
        // );
        // $rate = $tax_manager->getTaxCalculator()->getTotalRate();
        // $address = new Address();
        // $address->id_country = $country->id;


        if ($newPrice > $product->price) {
            //FIXER LE PRIX
            $newspec->price = $newPrice;
            $newspec->reduction = 0;
        } else {
            //FAIRE UNE REDUC
            $newspec->price = -1;
            $newspec->reduction = $product->price - $newPrice;
        }

        // if (isset($id_product)) {
        //     $newspec->id_product = (int) $id_product;
        //     $newspec->id_product_attribute = (int) $id;
        //     $newspec->reduction = Tools::ps_round(abs($oldprice - $value), 2);
        // } else {
        //     $newspec->id_product = (int) $id;
        //     $newspec->id_product_attribute = '';
        //     $newspec->reduction = Tools::ps_round(abs($oldprice - $value), 2);
        // }
        $newspec->from_quantity = 1;
        $newspec->reduction_tax = 0;
        $newspec->reduction_type = 'amount';
        $newspec->from = '0000-00-00 00:00:00';
        $newspec->to = '0000-00-00 00:00:00';

        // $newspec->from = null;
        // $newspec->to = null;


        $newspec->id_shop = $id_shop;

        $newspec->id_currency = 0;
        $newspec->id_country = 0;
        $newspec->id_group = 0;
        $newspec->id_customer = 0;

        // $newspec->id_currency = $this->context->currency->id;
        // $newspec->id_country = $country->id;



        $newSpecId =  $newspec->save();
        // $query = "UPDATE `" . _DB_PREFIX_ . "specific_price` SET `from`='1980-01-01 00:00:00', `to`='2100-01-01 00:00:00' WHERE `id_specific_price`=" . $newSpecId;
        // return   Db::getInstance()->executeS($query);
    }

    private function changeProductAttributePrice_mode_impact($id_product, $id_product_attribute, $price, $id_shop)
    {
        $query = 'SELECT price FROM  `' . _DB_PREFIX_ . 'product` WHERE id_product=' . $id_product;
        $price_result =    Db::getInstance()->executeS($query);

        if ($price_result == null || count($price_result) == 0) {
            throw new Exception("unable to update product price with mode_impact : Product base price is not set");
        }
        $price_result = $price_result[0]['price'];
        if ($price_result == null) {
            throw new Exception("unable to update product price with mode_impact : Product base price is not set");
        }
        $price_result = floatval($price_result);
        $impact_price = round($price  - $price_result, 2);
        // return  $impact_price;
        // return  $price_result;

        //all shop
        // $query = 'UPDATE `' . _DB_PREFIX_ . 'product_attribute` SET price=' . $impact_price . ' WHERE id_product_attribute=' . $id_product_attribute;

        //only shop
        $query = 'UPDATE `' . _DB_PREFIX_ . 'product_attribute_shop` SET price=' . $impact_price . ' WHERE id_product_attribute=' . $id_product_attribute;
        if (!empty($id_shop)) {
            $query .= ' AND id_shop=' . $id_shop;
        }


        return  Db::getInstance()->execute($query);
    }
    private function addSpecificPriceForAttribute($id_product, $id_product_attribute, $price, $id_shop)
    {
        if (empty($id_shop)) {
            $id_shop = 0;
        }
        $query = 'INSERT INTO `' . _DB_PREFIX_ . 'specific_price` (id_product,id_product_attribute,price,`from`,`to`,id_shop) VALUES(' . (int) $id_product . ',' . $id_product_attribute . ',' . $price . ',' . "'0000-00-00 00:00:00'" . ',' . "'0000-00-00 00:00:00'" . ',' .  $id_shop . ')';
        return  Db::getInstance()->execute($query);

        // $query = "UPDATE `" . _DB_PREFIX_ . "specific_price` SET `from`='1980-01-01 00:00:00', `to`='2100-01-01 00:00:00' WHERE `id_specific_price`=" . $newSpecId;
        // return   Db::getInstance()->executeS($query);
    }
    private function deleteSpecificPriceForAttribute($id_product, $id_product_attribute, $id_shop)
    {
        if (empty($id_shop)) {
            $id_shop = 0;
        }
        $query = 'DELETE FROM `' . _DB_PREFIX_ . 'specific_price` WHERE `id_product` = ' . (int) $id_product . ' AND `id_product_attribute` = ' . $id_product_attribute . ' AND id_shop=' . $id_shop;
        Db::getInstance()->execute($query);
    }
    private function updateProductPriceWithCleanSpecific($id, $prix_base, $prix_promo, $idShop)
    {
        if (empty($idShop)) {
            $idShop = null;
        }
        $product  = new Product($id, false, null, $idShop);
        if (!$product->id) {
            throw new Exception('No product with this id');
        }
        SpecificPrice::deleteByProductId($id);

        if ($prix_base != null) {
            if (!is_numeric($prix_base)) {
                throw new Exception('prix_base is not correct');
            }
            $prix_base = floatval($prix_base);
            $this->updateProductPriceBase($product, $prix_base, $idShop);
        }
        if ($prix_promo != null) {
            if ($prix_base != null) {
                $product->price = $prix_base;
            }
            if (!is_numeric($prix_promo)) {
                throw new Exception('prix_promo is not correct');
            }
            $prix_promo = floatval($prix_promo);
            $this->updateProductPricePromo($product, $prix_promo, $idShop);
        }
    }

    public function postProcess()
    {
        header('Content-type: application/json');
        $returned = array('success' => false, 'products' => array(), 'error' => null);
        try {

            $idShop = Tools::getValue('id_shop');
            // if (!$idShop) {
            //     throw new Exception('You must pass id_shop in query parameters');
            // }
            if (!empty($idShop)) {
                $idShop = (int)  $idShop;
            }

            // $entityBody = stream_get_contents(STDIN);
            $entityBody = file_get_contents('php://input');
            $items_array = null;

            if (!$entityBody) {
                throw new Exception('No body !');
            }
            $items_array = json_decode($entityBody, true);
            if (!is_array($items_array)) {
                throw new Exception('Invalid body !');
            }

            require_once dirname(__FILE__) . DIRECTORY_SEPARATOR . '../helpers.php';
            $advanced_pack_ids = NxsHelpers::getAdvancedPackIds();


            if (count($items_array) > 0) {
                foreach ($items_array as $item) {
                    $id = null;
                    if (isset($item['id'])) {
                        $id = $item['id'];
                    }
                    $id_declinaison = null;
                    if (isset($item['id_declinaison'])) {
                        $id_declinaison = $item['id_declinaison'];
                    }
                    try {
                        if (!isset($item['id']) && !isset($item['id_declinaison'])) {
                            continue;
                        }

                        $productIsAdvancedPack =  NxsHelpers::productIsAdvancedPack($id, $advanced_pack_ids);
                        $productIsPack =  NxsHelpers::productIsPack($id, $advanced_pack_ids);

                        if (!$productIsAdvancedPack && !isset($item['prix_base']) && !isset($item['prix_promo'])) {
                            throw new Exception('No price provided');
                        }
                        $prix_base = null;
                        $prix_promo = null;
                        $mode_impact = false;
                        $delete_specific_prices = false;

                        if (isset($item['prix_base'])) {
                            $prix_base = $item['prix_base'];
                        }
                        if (isset($item['prix_promo'])) {
                            $prix_promo = $item['prix_promo'];
                        }

                        if (isset($item['mode_impact'])) {
                            $mode_impact = $item['mode_impact'] === true || $item['mode_impact'] === 'true';
                        }
                        if (isset($item['delete_specific_prices'])) {
                            $delete_specific_prices = $item['delete_specific_prices'] === true || $item['delete_specific_prices'] === 'true';
                        }
                        if ($id_declinaison && !$productIsPack) {
                            // $query = "SELECT * FROM `" . _DB_PREFIX_ . "product_attribute` WHERE id_product_attribute=" . $id_declinaison;

                            $id =  $this->getProductFromAttributeId($id_declinaison);
                            if ($id == null) {
                                throw new Exception("Unable to find product id for declination : " . $id_declinaison);
                            }
                            if ($prix_base == null) {
                                throw new Exception("Unable to update price for declination : " . $id_declinaison . ' - no prix_base provided !');
                            }
                            $data_to_return_for_item = array('id' => $id, 'id_declinaison' => $id_declinaison, 'success' => false);

                            if ($delete_specific_prices || !$mode_impact) {
                                $this->deleteSpecificPriceForAttribute($id, $id_declinaison, $idShop);
                            }
                            if (!$mode_impact) {
                                $data_to_return_for_item['success'] = $this->addSpecificPriceForAttribute($id, $id_declinaison, $prix_base, $idShop);
                            } else {
                                // $data_to_return_for_item['price_base_product'] = $this->changeProductAttributePrice_mode_impact($id, $id_declinaison, $prix_base);
                                $returned_impact_price = $this->changeProductAttributePrice_mode_impact($id, $id_declinaison, $prix_base, $idShop);
                                // $data_to_return_for_item['price_base_product'] = $returned_impact_price;

                                $data_to_return_for_item['success'] = $returned_impact_price;
                            }

                            // $results =  $this->getProductAttributes($id_declinaison);
                            // $results = Db::getInstance()->executeS($query);

                            $returned['products'][] = $data_to_return_for_item;
                        } else {
                            if ($productIsPack) {
                                // throw new Exception("This product is a pack : todo");
                                if ($productIsAdvancedPack) {
                                    if ($prix_base != null) {
                                        if (!is_numeric($prix_base)) {
                                            throw new Exception('prix_base is not correct');
                                        }
                                        $query_result =  Db::getInstance()->executeS('update `' . _DB_PREFIX_ . 'pm_advancedpack` SET fixed_price=' . $prix_base  . ' WHERE id_pack=' . $id);
                                        $returned['products'][] = array('id' => $id, 'success' => $query_result);
                                    } else {
                                        $query_result =  Db::getInstance()->executeS('update `' . _DB_PREFIX_ . 'pm_advancedpack` SET fixed_price=NULL WHERE id_pack=' . $id);
                                        $returned['products'][] = array('id' => $id, 'success' => $query_result);
                                    }
                                } else {
                                    //update native pack
                                    $product  = new Product($id);
                                    if (!$product->id) {
                                        throw new Exception('No product with this id');
                                    }

                                    if ($prix_base != null) {
                                        if (!is_numeric($prix_base)) {
                                            throw new Exception('prix_base is not correct');
                                        }
                                        $prix_base = floatval($prix_base);
                                        $this->updateProductPriceBase($product, $prix_base, $idShop);
                                        $returned['products'][] = array('id' => $id, 'success' => true);
                                    } else {
                                        //TODO
                                    }
                                }
                            } else {
                                $results =  $this->getProductAttributes($id);
                                if (count($results) === 0) {
                                    $this->updateProductPriceWithCleanSpecific($id, $prix_base, $prix_promo, $idShop);
                                    $returned['products'][] = array('id' => $id, 'success' => true);
                                } else {
                                    throw new Exception("This product has declinations : please update each declination");
                                }
                            }
                        }
                        // $specprices = SpecificPrice::getByProductId($id);

                        // $returned['list'][] = $product;
                        // $returned['updated']++;
                    } catch (Exception $item_exc) {
                        $dataToAdd = array('success' => false, 'error' => $item_exc->getMessage());
                        if ($id_declinaison) {
                            $dataToAdd['id_declinaison'] = $id_declinaison;
                        }
                        if ($id) {
                            $dataToAdd['id'] = $id;
                        }
                        $returned['products'][] =  $dataToAdd;
                    }
                }
            }
            $returned['success'] = true;
        } catch (Exception $err) {
            $returned['success'] = false;
            $returned['error'] = $err->getMessage();
        }
        die(Tools::jsonEncode($returned));
    }
}
