<?php

/**
 * @author InterAgilite
 * @copyright 2007-2020 PrestaShop SA
 * @license   http://opensource.org/licenses/afl-3.0.php  Academic Free License (AFL 3.0)
 * International Registered Trademark & Property of PrestaShop SA
 * <ModuleName> => prixanconnect
 * <FileName> => ProductsCount.php
 * Format expected: <ModuleName><FileName>ModuleFrontController
 */

class PrixanconnectProductsCountModuleFrontController extends ModuleFrontController
{
    // $this->module is the instance of the module responsible of the controller.
    // $this->context delivers the result of Context::getContext()

    public function initContent()
    {
        $this->ajax = true;
        //  header('Content-disposition: attachment; filename=liste-produits.json');
        header('Content-type: application/json');

        $cle_module = Configuration::get('PRIXANCONNECT_CLE');
        if (Tools::getValue('key') == false || Tools::getValue('key') != $cle_module) {
            die(Tools::jsonEncode('erreur d\'autorisation'));
            return;
        }
        //parametre
        // $idShop = 1;

        $only_active = 1;
        if (Tools::getValue('only_active') != null && ((int) Tools::getValue('only_active'))  === 0) {
            $only_active = 0;
        }

        $idShop = (int) $this->context->shop->id;
        if (Tools::getValue('id_shop') != null && (int) Tools::getValue('id_shop')  > 0) {
            $idShop = (int) Tools::getValue('id_shop');
        }

        $langID = (int) Configuration::get('PS_LANG_DEFAULT');

        if (Tools::getValue('id_lang') != null && (int) Tools::getValue('id_lang') > 0) {
            $langID = (int) Tools::getValue('id_lang');
        }

        $count_response = array('total' => 0);
        // die(Tools::jsonEncode($count_response));

        try {
            $query  = "SELECT COUNT(prshop.`id_product`) as total
            FROM `" . _DB_PREFIX_ . "product_shop` AS prshop
            WHERE prshop.`id_shop` = " . $idShop;
            if ($only_active === 1) {
                $query .= " AND prshop.`active` = 1 ";
            }

            $count_response = Db::getInstance()->executeS($query);
            if (is_array($count_response) && count($count_response) > 0) {
                $count_response = $count_response[0];
                $count_response['total'] = intval($count_response['total']);
            } else {
                $count_response = array('total' => 0);
            }
        } catch (Exception $exc) {
        }

        die(Tools::jsonEncode($count_response));
    }
}
